//
//  GSHint.h
//  GlyphsCore
//
//  Created by Georg Seifert on 21.01.09.
//  Copyright 2009 schriftgestaltung.de. All rights reserved.
//

#import <Cocoa/Cocoa.h>
#import "GSElement.h"
@class GSNode;

typedef enum {
	Tag = -2,
	TopGhost = -1,
	Stem = 0,
	BottomGhost = 1,
	Align = 2,
	Interpolate = 3,
	Diagonal = 4,
	Auto = NSNotFound,
} GSHintType;

@interface GSHint : GSElement <NSCoding, NSCopying> {

	GSNode					*_originNode;
	GSNode					*_targetNode;
	GSNode					*_otherNode1;
	GSNode					*_otherNode2;
	NSIndexPath				*_originIndex;
	NSIndexPath				*_targetIndex;
	NSIndexPath				*_otherIndex1;
	NSIndexPath				*_otherIndex2;
	
	GSHintType				_type;
	NSRect					_badgeRect;
	NSPoint					_originKnob;
	NSPoint					_targetKnob;
	NSPoint					_otherKnob1;
	NSPoint					_otherKnob2;
	int						_selection;
	NSInteger				_stem;
	NSString					*_name;
@public
	CGFloat					_origin;
	CGFloat					_width;
	BOOL					_horizontal;
}

@property(nonatomic) CGFloat			origin;
@property(nonatomic) CGFloat			width;
@property(nonatomic) BOOL				horizontal;
@property(strong, nonatomic) GSNode		*originNode;
@property(strong, nonatomic) GSNode		*targetNode;
@property(strong, nonatomic) GSNode		*otherNode1;
@property(strong, nonatomic) GSNode		*otherNode2;
@property(strong, nonatomic) NSIndexPath*originIndex;
@property(strong, nonatomic) NSIndexPath*targetIndex;
@property(strong, nonatomic) NSIndexPath*otherIndex1;
@property(strong, nonatomic) NSIndexPath*otherIndex2;
@property(nonatomic) GSHintType			type;
@property(nonatomic) NSRect				badgeRect;
@property(nonatomic) NSPoint			originKnob;
@property(nonatomic) NSPoint			targetKnob;
@property(nonatomic) NSPoint			otherKnob1;
@property(nonatomic) NSPoint			otherKnob2;

@property(nonatomic) int				selection;
@property (nonatomic) NSInteger			stem;
@property (nonatomic, strong) NSString* name;

- (id) initWithHintDict:(NSDictionary*) HintDict;
- (void) makeGhost;
- (void) save ;
- (void) restore ;
- (void) updateIndexes ;
- (NSSet*) dependenIndexes ;
- (NSSet*) touchingIndexes ;
- (NSSet*) touchingIndexesAlreadyTouched:(NSSet*) AlreadyTouchedIndexes;
@end
